/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.dom.Annotation;
import org.autoplot.dom.Application;
import org.autoplot.dom.Axis;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.ChangesSupport;
import org.autoplot.dom.Column;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DebugPropertyChangeSupport;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.LabelConverter;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.Row;
import org.das2.util.LoggerManager;

public class DomNodeController {
    protected static final Logger logger = LoggerManager.getLogger((String)"autoplot.dom");
    DomNode node;
    protected PropertyChangeSupport propertyChangeSupport = new DebugPropertyChangeSupport(this);
    protected final ChangesSupport changesSupport = new ChangesSupport(this.propertyChangeSupport, this);
    private static final WeakHashMap<DomNode, Long> instances = new WeakHashMap();
    private static final long t0 = System.currentTimeMillis();

    public DomNodeController(DomNode node) {
        this.node = node;
        instances.put(node, System.currentTimeMillis() - t0);
    }

    public static void printStats() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<DomNode, Long> t : instances.entrySet()) {
            list.add(t.getKey() + " " + t.getValue());
        }
        Collections.sort(list);
        for (String s : list) {
            System.err.println(s);
        }
        System.err.println("(" + list.size() + " items)");
    }

    protected static String insertString(String title, String label, String value) {
        return LabelConverter.insertString(title, label, value);
    }

    protected static boolean containsString(String ptitle, String label, String value) {
        return LabelConverter.containsString(ptitle, label, value);
    }

    public static DomNodeController getController(DomNode n) {
        DomNodeController result = n instanceof PlotElement ? ((PlotElement)n).getController() : (n instanceof Plot ? ((Plot)n).getController() : (n instanceof DataSourceFilter ? ((DataSourceFilter)n).getController() : (n instanceof Application ? ((Application)n).getController() : (n instanceof Axis ? ((Axis)n).getController() : (n instanceof Row ? ((Row)n).getController() : (n instanceof Column ? ((Column)n).getController() : (n instanceof Canvas ? ((Canvas)n).getController() : (n instanceof Annotation ? ((Annotation)n).getController() : null))))))));
        return result;
    }

    private List<DomNodeController> getChildControllers() {
        ArrayList<DomNodeController> result = new ArrayList<DomNodeController>();
        List<DomNode> kids = this.node.childNodes();
        for (DomNode k : kids) {
            DomNodeController kc = DomNodeController.getController(k);
            if (kc == null) continue;
            result.add(kc);
        }
        return result;
    }

    public boolean isPendingChanges() {
        if (this.changesSupport.isPendingChanges()) {
            return true;
        }
        List<DomNodeController> kids = this.getChildControllers();
        for (DomNodeController k : kids) {
            if (!k.isPendingChanges()) continue;
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Node is pending changes: {0}", k);
                LinkedHashMap<Object, Object> changesPending = new LinkedHashMap<Object, Object>();
                k.pendingChanges(changesPending);
                for (Map.Entry e : changesPending.entrySet()) {
                    logger.log(Level.FINER, "{0} -> {1}", new Object[]{e.getKey(), e.getValue()});
                }
            }
            return true;
        }
        return false;
    }

    public void pendingChanges(Map<Object, Object> changes) {
        Map lchangesPending = this.changesSupport.getChangesPending();
        if (!lchangesPending.isEmpty()) {
            changes.putAll(lchangesPending);
        }
        List<DomNodeController> kids = this.getChildControllers();
        for (DomNodeController k : kids) {
            k.pendingChanges(changes);
        }
    }

    public boolean isValueAdjusting() {
        return this.changesSupport.isValueAdjusting() != null;
    }

    public ChangesSupport.DomLock mutatorLock() {
        return this.changesSupport.mutatorLock();
    }

    public void registerPendingChange(Object client, Object lockObject) {
        this.changesSupport.registerPendingChange(client, lockObject);
    }

    public void performingChange(Object client, Object lockObject) {
        this.changesSupport.performingChange(client, lockObject);
    }

    public void changePerformed(Object client, Object lockObject) {
        this.changesSupport.changePerformed(client, lockObject);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }
}

